/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;

public class Tool
implements IDeliverable {
    private static final Set<TypeToken<?>> TYPE_TOKENS = ReflectionUtils.getSuperClasses(TypeToken.of(Tool.class)).stream().filter(type -> !type.equals(TypeConstants.OBJECT)).collect(Collectors.toSet());
    private static final String NBT_TYPE = "Type";
    private static final String NBT_MIN_LEVEL = "MinLevel";
    private static final String NBT_MAX_LEVEL = "MaxLevel";
    private static final String NBT_RESULT = "Result";
    @NotNull
    private final IToolType toolClass;
    @NotNull
    private final Integer minLevel;
    @NotNull
    private final Integer maxLevel;
    @NotNull
    private ItemStack result = ItemStackUtils.EMPTY;

    public Tool(@NotNull IToolType toolClass, @NotNull Integer minLevel, @NotNull Integer maxLevel) {
        this(toolClass, minLevel, maxLevel, ItemStackUtils.EMPTY);
    }

    public Tool(@NotNull IToolType toolClass, @NotNull Integer minLevel, @NotNull Integer maxLevel, @NotNull ItemStack result) {
        this.toolClass = toolClass;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
        this.result = result;
    }

    @NotNull
    public static CompoundTag serialize(IFactoryController controller, Tool tool) {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_(NBT_TYPE, tool.getToolClass().getName());
        compound.m_128405_(NBT_MIN_LEVEL, tool.getMinLevel().intValue());
        compound.m_128405_(NBT_MAX_LEVEL, tool.getMaxLevel().intValue());
        compound.m_128365_(NBT_RESULT, (Tag)tool.getResult().serializeNBT());
        return compound;
    }

    @NotNull
    public static Tool deserialize(IFactoryController controller, CompoundTag nbt) {
        IToolType type = ToolType.getToolType(nbt.m_128461_(NBT_TYPE));
        Integer minLevel = nbt.m_128451_(NBT_MIN_LEVEL);
        Integer maxLevel = nbt.m_128451_(NBT_MAX_LEVEL);
        ItemStack result = ItemStack.m_41712_((CompoundTag)nbt.m_128469_(NBT_RESULT));
        return new Tool(type, minLevel, maxLevel, result);
    }

    public static void serialize(IFactoryController controller, FriendlyByteBuf buffer, Tool input) {
        buffer.m_130070_(input.getToolClass().getName());
        buffer.writeInt(input.getMinLevel().intValue());
        buffer.writeInt(input.getMaxLevel().intValue());
        buffer.writeBoolean(ItemStackUtils.isEmpty(input.result) == false);
        if (!ItemStackUtils.isEmpty(input.result).booleanValue()) {
            buffer.m_130055_(input.result);
        }
    }

    public static Tool deserialize(IFactoryController controller, FriendlyByteBuf buffer) {
        IToolType type = ToolType.getToolType(buffer.m_130136_(Short.MAX_VALUE));
        int minLevel = buffer.readInt();
        int maxLevel = buffer.readInt();
        ItemStack result = buffer.readBoolean() ? buffer.m_130267_() : ItemStack.f_41583_;
        return new Tool(type, minLevel, maxLevel, result);
    }

    @NotNull
    public IToolType getToolClass() {
        return this.toolClass;
    }

    @NotNull
    public Integer getMinLevel() {
        return this.minLevel;
    }

    @NotNull
    public Integer getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    @Override
    public boolean matches(@NotNull ItemStack stack) {
        boolean toolTypeResult;
        boolean bl = toolTypeResult = ItemStackUtils.isEmpty(stack) == false && stack.m_41613_() >= 1 && this.getToolClasses(stack).stream().filter(s -> this.getToolClass().getName().equalsIgnoreCase((String)s)).map(ToolType::getToolType).anyMatch(t -> t != ToolType.NONE && (stack.m_41773_() > 0 || !stack.m_41768_()) && ItemStackUtils.hasToolLevel(stack, t, this.getMinLevel(), this.getMaxLevel()));
        if (!toolTypeResult) {
            return stack.m_41720_() instanceof ShieldItem && this.toolClass.equals(ToolType.SHIELD) || stack.m_41720_() instanceof FlintAndSteelItem && this.toolClass.equals(ToolType.FLINT_N_STEEL);
        }
        return toolTypeResult;
    }

    private Set<String> getToolClasses(ItemStack stack) {
        HashSet<String> set = new HashSet<String>();
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return set;
        }
        if (stack.canPerformAction(ToolActions.AXE_DIG)) {
            set.add(ToolType.AXE.getName());
        }
        if (stack.canPerformAction(ToolActions.PICKAXE_DIG)) {
            set.add(ToolType.PICKAXE.getName());
        }
        if (stack.canPerformAction(ToolActions.SHOVEL_DIG)) {
            set.add(ToolType.SHOVEL.getName());
        }
        if (stack.canPerformAction(ToolActions.HOE_DIG)) {
            set.add(ToolType.HOE.getName());
        }
        if (stack.canPerformAction(ToolActions.SWORD_SWEEP)) {
            set.add(ToolType.SWORD.getName());
        }
        if (stack.m_41720_() instanceof BowItem) {
            set.add("bow");
        } else if (stack.m_41720_() instanceof SwordItem || Compatibility.isTinkersWeapon(stack)) {
            set.add("weapon");
        } else if (stack.m_41720_() instanceof HoeItem) {
            set.add(ToolType.HOE.getName());
        } else if (stack.m_41720_() instanceof FishingRodItem) {
            set.add("rod");
        } else if (stack.m_41720_() instanceof ShearsItem) {
            set.add("shears");
        } else if (stack.m_41720_() instanceof ShieldItem) {
            set.add("shield");
        } else if (stack.m_41720_() instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)stack.m_41720_();
            if (armor.m_40402_() == EquipmentSlot.CHEST) {
                set.add("chestplate");
            } else if (armor.m_40402_() == EquipmentSlot.FEET) {
                set.add("boots");
            } else if (armor.m_40402_() == EquipmentSlot.HEAD) {
                set.add("helmet");
            } else if (armor.m_40402_() == EquipmentSlot.LEGS) {
                set.add("leggings");
            }
        }
        return set;
    }

    public boolean isArmor() {
        return this.toolClass == ToolType.HELMET || this.toolClass == ToolType.LEGGINGS || this.toolClass == ToolType.CHESTPLATE || this.toolClass == ToolType.BOOTS;
    }

    @Override
    public int getCount() {
        return 1;
    }

    @Override
    public int getMinimumCount() {
        return 1;
    }

    @Override
    public void setResult(@NotNull ItemStack result) {
        this.result = result;
    }

    @Override
    public IDeliverable copyWithCount(@NotNull int newCount) {
        return new Tool(this.toolClass, this.minLevel, this.maxLevel, this.result);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tool)) {
            return false;
        }
        Tool tool = (Tool)o;
        if (!this.getToolClass().equals(tool.getToolClass())) {
            return false;
        }
        if (!this.getMinLevel().equals(tool.getMinLevel())) {
            return false;
        }
        if (!this.getMaxLevel().equals(tool.getMaxLevel())) {
            return false;
        }
        return ItemStackUtils.compareItemStacksIgnoreStackSize(this.getResult(), tool.getResult());
    }

    public int hashCode() {
        int result1 = this.getToolClass().hashCode();
        result1 = 31 * result1 + this.getMinLevel().hashCode();
        result1 = 31 * result1 + this.getMaxLevel().hashCode();
        result1 = 31 * result1 + this.getResult().hashCode();
        return result1;
    }

    @Override
    public Set<TypeToken<?>> getSuperClasses() {
        return TYPE_TOKENS;
    }
}

